<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>" name="description">
    <meta content="<?php echo e(is_array(@$pageSeo['meta_keywords']) ? implode(', ', @$pageSeo['meta_keywords']) : @$pageSeo['meta_keywords']); ?>"
          name="keywords">
    <meta name="theme-color" content="<?php echo e(basicControl()->primary_color); ?>">
    <meta name="author" content="<?php echo e(basicControl()->site_title); ?>">
    <meta name="robots" content="<?php echo e(isset($pageSeo['meta_robots']) ? $pageSeo['meta_robots'] : ''); ?>">

    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo e(isset(basicControl()->site_title) ? basicControl()->site_title : ''); ?>">
    <meta property="og:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta property="og:description" content="<?php echo e(isset($pageSeo['og_description']) ? $pageSeo['og_description'] : ''); ?>">
    <meta property="og:image" content="<?php echo e(getFile(@$pageSeo['meta_image_driver'], @$pageSeo['meta_image'])); ?>">

    <meta name="twitter:card" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta name="twitter:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta name="twitter:description" content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>">
    <meta name="twitter:image" content="<?php echo e(getFile(@$pageSeo['meta_image_driver'], @$pageSeo['meta_image'])); ?>">
    <!-- Favicons -->
    <link href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>" rel="icon">
    <title> <?php echo e(basicControl()->site_title); ?>

        <?php if(isset($pageSeo['page_title'])): ?>
            | <?php echo app('translator')->get(str_replace(basicControl()->site_title, ' ',$pageSeo['page_title'])); ?>
        <?php else: ?>
             | <?php echo $__env->yieldContent('title'); ?>
        <?php endif; ?>
    </title>

    <!-- Stylesheets -->
    <link href="<?php echo e(asset(template(true).'css/style.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('style'); ?>
    <?php echo $__env->yieldPushContent('css-lib'); ?>
    <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>

</head>

<body>
<div class="page-wrapper">
    <!-- preloader -->
    <div class="loader-wrap">
        <div class="preloader">
            <div class="preloader-close">x</div>
            <div id="handle-preloader" class="handle-preloader">
                <div class="animation-preloader">
                    <div class="loader-image">
                        <img src="<?php echo e(asset(template(true).'images/loader.gif')); ?>" alt="loader">
                    </div>
                    <div class="txt-loading">
                        <?php $__currentLoopData = loader(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charecter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($charecter == " "): ?>
                                <span data-text-preloader="<?php echo e($charecter); ?>" class="letters-loading ml_15">
                               <?php echo e($charecter); ?>

                                </span>
                            <?php else: ?>
                                <span data-text-preloader="<?php echo e($charecter); ?>" class="letters-loading">
                               <?php echo e($charecter); ?>

                                </span>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- preloader end -->

    <?php echo $__env->make(template().'partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make(template().'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make(template().'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php echo $__env->make(template().'partials.cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!--Scroll to top-->
<div class="scroll-to-top">
    <div>
        <div class="scroll-top-inner">
            <div class="scroll-bar">
                <div class="bar-inner"></div>
            </div>
            <div class="scroll-bar-text"><?php echo app('translator')->get('Go To Top'); ?></div>
        </div>
    </div>
</div>
<!-- Scroll to top end -->

<script src="<?php echo e(asset('assets/global/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/jquery.nice-select.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/appear.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/wow.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/owl.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/TweenMax.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/odometer.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/swiper.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/parallax-scroll.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/jarallax.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/jquery.paroller.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/jquery.magnific-popup.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/isotope.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/flatpickr-min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/socialSharing.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/nouislider.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/script.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/axios.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>
<?php echo $__env->make(template().'partials.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="<?php echo e(asset(template(true).'js/order.js')); ?>"></script>

<?php echo $__env->yieldPushContent('js-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->make(template().'partials.pwa', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script>
    $(document).ready(function() {
        // Get the modal
        var $modal = $("#myModal");

        // When the user clicks the button, open the modal
        $(document).on('click', '.myBtn', function (){
            $modal.show();
        });

        // When the user clicks on <span> (x), close the modal
        $(document).on('click', '.close', function() {
            $modal.hide();
        });

        // When the user clicks the close button in the footer, close the modal
        $(document).on('click', '.close-modal', function() {
            $modal.hide();
        });

        // When the user clicks anywhere outside of the modal, close it
        $(window).on('click', function(event) {
            if ($(event.target).is($modal)) {
                $modal.hide();
            }
        });
    });

    $(document).on('click','.planPurchaseSubmitButton',function (){
        $(this).attr('disabled', true);
        $('#myModal').hide();
        setTimeout(() => {
            $(this).closest('form').submit();
        }, 200);
    })

    $(document).on('click','.myBtn',function (){
        let plan =  $(this).data('plan');
        let invest = $(this).data('invest');
        let profit = $(this).data('profit');
        let period = $(this).data('period');
        $('#PlanName').text(plan);
        $('.price-range').text('Invest : '+invest);
        $('.profit-details').text('Profit : '+profit);
        $('.profit-validity').text('Return Period : '+period)
        $('.plan-id').val($(this).data('id'));
        $('.number_of_return').text('Number of Return : ' + $(this).data('return_number'));

    })

</script>


<script>
    "use strict";
    var root = document.querySelector(':root');
    root.style.setProperty('--primary', '<?php echo e(basicControl()->primary_color); ?>');
    root.style.setProperty('--secondary', '<?php echo e(basicControl()->secondary_color); ?>');
</script>


<?php if(session()->has('success')): ?>
    <script>
        Notiflix.Notify.success("<?php echo app('translator')->get(session('success')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <script>
        Notiflix.Notify.failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
    <script>
        Notiflix.Notify.warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>
<?php endif; ?>



</body>

</html>


<?php /**PATH D:\server\htdocs\bullion\demo\resources\views/themes/light/layouts/app.blade.php ENDPATH**/ ?>